hfig=figure('Name',['Wind Profiles for  ',datestr(lidar.start_time,'mm/dd/yy HH:MM:SS')],'Position',[50 50 1000 800]);

set(hfig,'Name',['Wind Conditions ',datestr(lidar.start_time),' UTC'],'NumberTitle','off')
subplot(1,4,1)
plot(profile.Vh,profile.heights','linewidth',3)
grid on
haxe1=gca;
set(haxe1,'fontsize',12,'fontweight','b')
xlabel('Horizontal Wind (m/s)','fontsize',14,'fontweight','b')
ylabel('Height AGL (m)','fontsize',14,'fontweight','b')
axis(haxe1,[0 20 0 1000])
text(20,1025,['Wind Conditions ',datestr(vad.start_time),' UTC'],'fontsize',14,'fontweight','b')
set(haxe1,'XTick',[0 5 10 15 20])
subplot(1,4,2)
scatter(profile.theta,profile.heights,'linewidth',3)
grid on
haxe2=gca;
set(haxe2,'fontsize',12,'fontweight','b')
xlabel('Direction','fontsize',14,'fontweight','b')
% ylabel('','FontName','')
set(haxe2,'YTickLabel','')
axis([0 360 0 1000])

set(haxe2,'XTick',[0 90 180 270 360])
subplot(1,4,3)
plot(profile.w,profile.heights,'linewidth',3)
grid on
haxe3=gca;
set(haxe3,'fontsize',12,'fontweight','b')
xlabel('Vertical Wind (m/s)','fontsize',14,'fontweight','b')
axis([-5 5 0 1000])
set(haxe3,'XTick',[-5 0 5])

set(haxe3,'YTickLabel','')

subplot(1,4,4)
plot(profile.shear,profile.heights,'linewidth',3)
grid on
haxe4=gca;
set(haxe4,'fontsize',12,'fontweight','b')
xlabel('Shear (m/s)','fontsize',14,'fontweight','b')
axis([0 .1 0 1000])
set(haxe4,'XTick',[0 .05 .1])

set(haxe4,'YTickLabel','')